IF NOT OBJECT_ID('TRG_EST_NF_ENT_DAR_PEND_INSERT') IS NULL
	BEGIN 
		DROP TRIGGER TRG_EST_NF_ENT_DAR_PEND_INSERT 
	END 

GO

CREATE TRIGGER TRG_EST_NF_ENT_DAR_PEND_INSERT ON EST_NF_ENT_IT FOR INSERT, UPDATE
AS
	BEGIN	
		IF UPDATE(FLAG_N_GERAR_DAR)
			BEGIN
				CREATE TABLE #EST_NF_ENT_DAR_PEND (CD_EMP		INT,
													CD_FILIAL	INT,
													CD_NF		INT,
													DT_ENT		DATETIME)
													
				-----------------------------------------------------------------------
				--INSERINDO PRIMEIRO NA TABELA DE PENDENCIA TEMPORARIA PARA EVIDAR A DUPLICIDADE
				-----------------------------------------------------------------------
				INSERT INTO #EST_NF_ENT_DAR_PEND
					(CD_EMP, CD_FILIAL, CD_NF, DT_ENT)
					
					SELECT  
						DISTINCT   	
						EST_NF_ENT.CD_EMP, 
						EST_NF_ENT.CD_FILIAL, 
						EST_NF_ENT.CD_NF,
						EST_NF_ENT.DT_ENT						
					FROM           
						inserted I 
						INNER JOIN EST_NF_ENT ON   
						EST_NF_ENT.CD_EMP = I.CD_EMP AND   
						EST_NF_ENT.CD_FILIAL = I.CD_FILIAL AND   
						EST_NF_ENT.CD_NF = I.CD_NF   AND 
						EST_NF_ENT.DT_ENT = I.DT_ENT
						INNER JOIN GLB_MOV_OP ON   
						EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP   
						
						--OUTER APPLY UFD_GLB_PESSOA(EST_NF_ENT.CD_FORN, GLB_MOV_OP.DEST_ORIG) GLB_PESSOA   
						INNER JOIN V_GLB_PESSOA GLB_PESSOA ON   
						EST_NF_ENT.CD_EMP	= GLB_PESSOA.CD_EMP AND   
						EST_NF_ENT.CD_FORN	= GLB_PESSOA.CD_PESSOA  AND
						GLB_MOV_OP.DEST_ORIG= GLB_PESSOA.DEST_ORIG
						
						INNER JOIN GLB_CID ON
						GLB_PESSOA.CD_CID = GLB_CID.CD_CID 

						INNER JOIN V_EST_PROD_CPL_TRIB_INTER_DAR ON   
						I.CD_EMP = V_EST_PROD_CPL_TRIB_INTER_DAR.CD_EMP AND   
						I.CD_FILIAL = V_EST_PROD_CPL_TRIB_INTER_DAR.CD_FILIAL AND   						
						I.CD_PROD = V_EST_PROD_CPL_TRIB_INTER_DAR.CD_PROD  AND 
						 						  
						GLB_CID.UF COLLATE SQL_Latin1_General_CP1_CI_AS = V_EST_PROD_CPL_TRIB_INTER_DAR.UF COLLATE SQL_Latin1_General_CP1_CI_AS AND
						GLB_MOV_OP.TP_MOV = V_EST_PROD_CPL_TRIB_INTER_DAR.TP_MOV

						INNER JOIN EST_TRIB_DARE_GERACAO ON 
						I.CD_TRIB = EST_TRIB_DARE_GERACAO.CD_TRIB	

						LEFT OUTER JOIN EST_NF_ENT_DAR  ON
						EST_NF_ENT.CD_EMP = EST_NF_ENT_DAR.CD_EMP AND 
						EST_NF_ENT.CD_FILIAL = EST_NF_ENT_DAR.CD_FILIAL AND 
						EST_NF_ENT.CD_NF = EST_NF_ENT_DAR.CD_NF
						
					WHERE          
						EST_NF_ENT_DAR.CD_NF IS NULL
						AND EST_NF_ENT.CD_EMP=1
						AND GLB_MOV_OP.TP_MOV_OP_TRANSA = 0 
						AND GLB_MOV_OP.FLAG_GERA_DARE=1
						AND GLB_PESSOA.SUBS_TRIB = 1 
						AND GLB_PESSOA.TP_SUBS_TRIB = 1 
						AND TP_GERACAO_DARE <> 3	
						 

						AND NOT EXISTS (SELECT P.CD_EMP 
										FROM EST_NF_ENT_DAR_PEND P
										WHERE P.CD_EMP = EST_NF_ENT.CD_EMP
											AND P.CD_FILIAL = EST_NF_ENT.CD_FILIAL
											AND P.CD_NF = EST_NF_ENT.CD_NF
											AND P.DT_ENT = EST_NF_ENT.DT_ENT)
						
 				
				-----------------------------------------------------------------------
				--INSERINDO NA TABELA DE PENDENCIA DE PROCESSAMENTO DO DAR
				-----------------------------------------------------------------------
				INSERT INTO EST_NF_ENT_DAR_PEND
					(CD_EMP, CD_FILIAL, CD_NF, DT_ENT, DT_CAD)
					
				SELECT 
					T.CD_EMP, T.CD_FILIAL, T.CD_NF, T.DT_ENT, GETDATE()
				FROM #EST_NF_ENT_DAR_PEND T
				
			END
	END